package com.company.model;

import com.company.exceptions.DuplicatedDataException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LectureContainer {
    private List<Lecture> lectures;
    private Lecture search(String initials) {
        Lecture  lecture;
        Iterator<Lecture> it = this.lectures.iterator();
        while(it.hasNext()){
            lecture = it.next();
            if(lecture.isEqualTo(initials)){
                return lecture;
            }
        }
        return null;
    }
    public LectureContainer(){
        lectures = new ArrayList<Lecture>();
    }
        public List<Lecture> getAll(){
            List<Lecture> newlist = new ArrayList();
            newlist.addAll(this.lectures);
            return newlist;
        }
        public Lecture get(String initials){
            Lecture lecture = search(initials);
            return lecture;
        }
        public void add(Lecture obj){
           Subject subject = obj.getSubject();
            Lecture lecture = search(subject.getInitials());
            if(lecture == null){
                this.lectures.add(obj);
            }else{
                String msg = "Lecture: " + subject.getInitials();
                throw  new DuplicatedDataException(msg);
            }
        }
        public void remove(String initials){
            Lecture lecture = search(initials);
            if(lecture != null){
                this.lectures.remove(lecture);
            }
        }


}
